/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authc.AuthInfoService;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.user.User;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class DlsFlsBaseContext {
    private final AuthInfoService authInfoService;
    private final AuthorizationService authorizationService;
    private final ThreadContext threadContext;

    DlsFlsBaseContext(AuthInfoService authInfoService, AuthorizationService authorizationService, ThreadContext threadContext) {
        this.authInfoService = authInfoService;
        this.authorizationService = authorizationService;
        this.threadContext = threadContext;
    }

    public PrivilegesEvaluationContext getPrivilegesEvaluationContext() {
        User user = this.authInfoService.peekCurrentUser();
        if (user == null) {
            return null;
        }
        SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext = this.authInfoService.getSpecialPrivilegesEvaluationContext();
        ImmutableSet mappedRoles = this.authorizationService.getMappedRoles(user, specialPrivilegesEvaluationContext);
        return new PrivilegesEvaluationContext(user, mappedRoles, null, null, false, null, specialPrivilegesEvaluationContext);
    }

    public boolean isDlsDoneOnFilterLevel() {
        return this.threadContext.getHeader("_sg_filter_level_dls_done") != null;
    }

    String getDoneDlsFilterLevelQuery() {
        return this.threadContext.getHeader("_sg_filter_level_dls_done");
    }
}

